//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////
//
// MAXtoA Test Plugin Dll entry point.

#include "MAXtoATestPlugin.h"
#include "MAXtoATestObject.h"
#include "MAXtoATestModifier.h"
#include <iparamb2.h>

#include "../../include/3dsmax_banned.h"

HINSTANCE hInstance;

BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    if (fdwReason == DLL_PROCESS_ATTACH)
    {
        MaxSDK::Util::UseLanguagePackLocale();
        hInstance = hinstDLL;				// Hang on to this DLL's instance handle.
        DisableThreadLibraryCalls(hInstance);
    }

    return TRUE;
}

__declspec(dllexport) const TCHAR* LibDescription()
{
    return _T("MAXtoA Test Plugin");
}

__declspec(dllexport) int LibNumberClasses()
{
    return 3;
}

__declspec(dllexport) ClassDesc* LibClassDesc(int i)
{
    switch (i) 
    {
    case 0:
        return &MAXtoATestPlugin::GetClassDesc();	
    case 1:
            return &MAXtoATestObject::GetClassDesc();
    case 2:
        return &MAXtoATestModifier::GetClassDesc();
    default:
        return NULL;
    }
}

__declspec(dllexport) ULONG LibVersion()
{
    return VERSION_3DSMAX;
}

__declspec(dllexport) ULONG CanAutoDefer()
{
    return 1;
}
